// pump_owl.cpp

#include <owl.h>
#include <toolhelp.h>
#include "resource.h"

class TMyApp : public TApplication
{
public:
  TMyApp(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();

  //  Override MessageLoop functions for performance
  //
  BOOL ProcessAccels    (LPMSG PMessage) {return FALSE;};
  BOOL ProcessAppMsg    (LPMSG PMessage) {return FALSE;};
  BOOL ProcessDlgMsg    (LPMSG PMessage) {return FALSE;};
  BOOL ProcessMDIAccels (LPMSG PMessage) {return FALSE;};
};

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow
{
private:
  long	m_lMsgCount;
	TIMERINFO m_ti;
	TIMERINFO FAR* m_lpti;
	DWORD 	m_dwStartTime  ,
		m_dwStopTime   ,
		m_dwCalibrationTime;
public:
  TMyWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
	 {
	 AssignMenu("MainMenu");
	 m_ti.dwSize = sizeof (TIMERINFO);
	 m_lpti      = &m_ti;
	 };

   void CMStartPostPump(RTMessage Msg) = [CM_FIRST + IDM_STARTPOSTMESSAGE];
   void CMStartSendPump(RTMessage Msg) = [CM_FIRST + IDM_STARTSENDMESSAGE];
   void WMUserPost(RTMessage Msg)      = [WM_FIRST + WM_USER];
   void WMUserSend(RTMessage Msg)      = [WM_FIRST + WM_USER+1];
};


void TMyWindow::CMStartPostPump(RTMessage)
{
 //  Calibrate message pump
 //
 SetCaption ("Calibrating Message Pump...");
 m_lMsgCount   = 0;
 ::TimerCount (m_lpti);
 m_dwStartTime = m_ti.dwmsSinceStart;

 if (m_lMsgCount < 10000)
 {
 m_lMsgCount++;
 }

 ::TimerCount (m_lpti);
 m_dwStopTime = m_ti.dwmsSinceStart;
 m_dwCalibrationTime = m_dwStopTime - m_dwStartTime;

 //  Now Start message pump
 //
 SetCaption ("Running 10,000 messages thru pump...");
 m_lMsgCount   = 0;
 ::TimerCount (m_lpti);
 m_dwStartTime = m_ti.dwmsSinceStart;
 PostMessage (HWindow, WM_USER, 0, 0);
}

void TMyWindow::WMUserPost (RTMessage)
	{
	char string [40];

	m_lMsgCount++;

	if (m_lMsgCount < 10000)
		{
		//	Keep message pump going
		//
		PostMessage (HWindow, WM_USER, 0, 0L);
		}

	else
		{
		//	Stop message pump & display msg rate
		//
		::TimerCount (m_lpti);
		m_dwStopTime = m_ti.dwmsSinceStart;

		DWORD dwElapsedTime = (m_dwStopTime - m_dwStartTime) - m_dwCalibrationTime;
		wsprintf (string, "BC w/OWL: Posted Msgs per second = %ld", (LONG) (1000. * ((double)m_lMsgCount/dwElapsedTime)));
		SetCaption (string);
		}
}

void TMyWindow::CMStartSendPump(RTMessage)
{
 //  Calibrate message pump
 //
 SetCaption ("Calibrating Message Pump...");
 m_lMsgCount   = 0;
 ::TimerCount (m_lpti);
 m_dwStartTime = m_ti.dwmsSinceStart;

 if (m_lMsgCount < 10000)
 {
 m_lMsgCount++;
 }

 ::TimerCount (m_lpti);
 m_dwStopTime = m_ti.dwmsSinceStart;
 m_dwCalibrationTime = m_dwStopTime - m_dwStartTime;

 //  Now Start message pump
 //
 SetCaption ("Sending 10,000 messages thru pump...");
 m_lMsgCount   = 0;
 ::TimerCount (m_lpti);
 m_dwStartTime = m_ti.dwmsSinceStart;

 while (m_lMsgCount < 10000)
      {
      SendMessage (HWindow, WM_USER+1, 0, 0);
      }
}

void TMyWindow::WMUserSend (RTMessage)
{
char string [40];

	 m_lMsgCount++;

	 if (m_lMsgCount >= 10000)
		{
		//	Stop message pump & display msg rate
		//
		::TimerCount (m_lpti);
		m_dwStopTime = m_ti.dwmsSinceStart;

		DWORD dwElapsedTime = (m_dwStopTime - m_dwStartTime) - m_dwCalibrationTime;
		wsprintf (string, "BC w/OWL: Sent Msgs per second = %ld", (LONG) (1000. * ((double)m_lMsgCount/dwElapsedTime)));
		SetCaption (string);
		}
}


void TMyApp::InitMainWindow()
{
  MainWindow = new TMyWindow(NULL, Name);
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp MyApp("Sample ObjectWindows Program", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
  MyApp.Run();
  return MyApp.Status;
}
